<?php

add_action( 'liquid_option_sidebars', 'liquid_woocommerce_option_sidebars' );

function liquid_woocommerce_option_sidebars( $obj ) {

	// Product Sidebar
	$obj->sections[] = array(
		'title'  => esc_html__('Products', 'logistics-hub'),
		'subsection' => true,
		'fields' => array(

			array(
				'id'       => 'wc-enable-global',
				'type'	   => 'button_set',
				'title'    => esc_html__( 'Activate Global Sidebar For Products', 'logistics-hub' ),
				'subtitle' => esc_html__( 'Turn on if you want to use the same sidebars on all product posts. This option overrides the product options.', 'logistics-hub' ),
				'options'  => array(
					'on'   => esc_html__( 'On', 'logistics-hub' ),
					'off'  => esc_html__( 'Off', 'logistics-hub' ),
				),
				'default' => 'off'
			),
			array(
				'id'       => 'wc-sidebar',
				'type'     => 'select',
				'title'    => esc_html__( 'Global Products Sidebar', 'logistics-hub' ),
				'subtitle' => esc_html__( 'Select sidebar that will display on all product posts.', 'logistics-hub' ),
				'data'     => 'sidebars'
			),
			array(
				'id'       => 'wc-sidebar-position',
				'type'     => 'button_set',
				'title'    => esc_html__( 'Global Products Sidebar Position', 'logistics-hub' ),
				'subtitle' => esc_html__( 'Controls the position of the sidebar for all product posts.', 'logistics-hub' ),
				'options'  => array(
					'left'  => esc_html__( 'Left', 'logistics-hub' ),
					'right' => esc_html__( 'Right', 'logistics-hub' )
				),
				'default' => 'right'
			),
		)
	);

	// Product Archive Sidebar
	$obj->sections[] = array(
		'title'  => esc_html__( 'Product Archive', 'logistics-hub' ),
		'subsection' => true,
		'fields' => array(
			array(
				'id'       =>'wc-archive-sidebar-one',
				'type'     => 'select',
				'title'    => esc_html__( 'Product Archive Sidebar', 'logistics-hub' ),
				'subtitle' => esc_html__( 'Select sidebar 1 that will display on the product archive pages.', 'logistics-hub' ),
				'data'     => 'sidebars'
			),
			array(
				'id'       => 'wc-archive-sidebar-position',
				'type'     => 'button_set',
				'title'    => esc_html__( 'Global Products Archive Sidebar Position', 'logistics-hub' ),
				'subtitle' => esc_html__( 'Controls the position of the sidebar for all product archives.', 'logistics-hub' ),
				'options'  => array(
					'left'  => esc_html__( 'Left', 'logistics-hub' ),
					'right' => esc_html__( 'Right', 'logistics-hub' )
				),
				'default' => 'right'
			),
			array(
				'id'       => 'wc-archive-shop-enable',
				'type'     => 'button_set',
				'title'    => esc_html__( 'Show Sidebar on Shop Page', 'logistics-hub' ),
				'subtitle' => esc_html__( 'Activate it on the WooCommerce shop page as well. WooCommerce > Settings > Products > Shop page', 'logistics-hub' ),
				'options'  => array(
					'yes'  => esc_html__( 'Yes', 'logistics-hub' ),
					'no' => esc_html__( 'No', 'logistics-hub' )
				),
				'default' => 'no'
			),
			array(
				'id'       => 'wc-archive-sidebar-hide-mobile',
				'type'	   => 'button_set',
				'title'    => esc_html__( 'Hide sidebar on mobile devices?', 'logistics-hub' ),
				'subtitle' => esc_html__( 'Turn on to hide the sidebar on mobile devices', 'logistics-hub' ),
				'options'  => array(
					'yes'   => esc_html__( 'Yes', 'logistics-hub' ),
					'no'  => esc_html__( 'No', 'logistics-hub' )
				),
				'default'  => 'no'
			),

		)
	);

}